/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.swing;

import frc.emul.api.persistence.PersistenceException;
import frc.emul.api.ui.IDisplay;
import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemGame;
import frc.emul.util.Utils;
import frc.emul.util.swing.FileRequester;
import frc.emul.util.tools.StateInjector;
import frc.emul.vectrex.PersistenceManager;
import frc.emul.vectrex.Vectrex;
import frc.emul.vectrex.VectrexMemory;
import frc.emul.vectrex.swing.UI;
import frc.emul.vectrex.swing.UIGameBuilder;
import frc.emul.vectrex.ui.GfxItem;
import frc.emul.vectrex.ui.HeadlessDisplay;
import frc.emul.vectrex.ui.PreviewCanvas;
import frc.emul.vectrex.ui.opengl.Display;
import frc.util.IStream;
import frc.util.IStreamFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

class UIInOut {
    private final UI ui;
    private JFileChooser snapshotChooser;
    private FileRequester storageChooser;
    private Integer resetAfterReload;

    public UIInOut(UI uI) {
        this.ui = uI;
    }

    private final Configuration getConfig() {
        return this.ui.getConfig();
    }

    private final IDisplay getDisplay() {
        return this.ui.getDisplay();
    }

    private final JFrame getWindow() {
        return this.ui.getWindow();
    }

    private final boolean isPaused() {
        return this.ui.isPaused();
    }

    private final void setPaused(boolean bl) {
        this.ui.setPaused(bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void snapshotImpls() {
        boolean bl;
        boolean bl2 = bl = !this.isPaused();
        if (bl) {
            this.setPaused(true);
        }
        try {
            Object object;
            Object object2;
            Object object3;
            JFileChooser jFileChooser = this.snapshotChooser;
            if (jFileChooser == null) {
                object3 = this.getConfig().options.lastPathSnapshots;
                this.snapshotChooser = jFileChooser = new JFileChooser((String)(object3 == null ? "." : object3));
                jFileChooser.setDialogTitle("Save Screenshot As...");
                jFileChooser.addChoosableFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return !file.isFile() || Display.isSupportedScreenShotFormat(file);
                    }

                    public String getDescription() {
                        return "*.bmp *.jpg *.png";
                    }
                });
                object2 = this.getConfig().getSelectedGame().info.getFilenameCandidate("picture", false);
                object = object3 == null ? new File((String)object3, (String)object2) : new File((String)object2);
                jFileChooser.setSelectedFile((File)object);
            }
            object3 = null;
            do {
                if (jFileChooser.showSaveDialog((Component)(object2 = this.getWindow())) != 0) {
                    return;
                }
                object3 = jFileChooser.getSelectedFile();
                if (object3 == null) {
                    return;
                }
                if ((object3 = Display.getSupportedScreenShotFormat((File)object3)) == null) {
                    object = jFileChooser.getSelectedFile().getName();
                    object = ((String)object).substring(((String)object).lastIndexOf(46) + 1).toUpperCase();
                    JOptionPane.showMessageDialog((Component)object2, "The " + (String)object + " image format is not supported, \nChoose BMP, JPG or PNG instead. ", "ParaJVE - ScreenShot", 2);
                    continue;
                }
                if (!((File)object3).exists() || JOptionPane.showConfirmDialog((Component)object2, "The specified image already exists : \"" + ((File)object3).getName() + "\" \nDo you want to overwrite its content? ", "ParaJVE - ScreenShot Overwrite?", 2) == 0) continue;
                object3 = null;
            } while (object3 == null);
            object2 = object3;
            this.storeLastPathSnapshots((File)object3);
            SwingUtilities.invokeLater(new Runnable((File)object2){
                private final /* synthetic */ File val$finalTarget;
                {
                    this.val$finalTarget = file;
                }

                public void run() {
                    UIInOut.this.getDisplay().takeScreenShot(this.val$finalTarget);
                }
            });
            bl = false;
            return;
        }
        finally {
            if (bl) {
                this.setPaused(false);
            }
        }
    }

    public void reloadRomsImpl() {
        boolean bl;
        boolean bl2 = bl = !this.isPaused();
        if (bl) {
            this.setPaused(true);
        }
        try {
            int n;
            String string;
            CfgItemGame cfgItemGame = this.getConfig().getSelectedGame();
            JFrame jFrame = this.getWindow();
            VectrexMemory vectrexMemory = Vectrex.INSTANCE.getMemory();
            int n2 = vectrexMemory.getSelectedCartBank();
            if (cfgItemGame == null || !UIInOut.loadCartridge(jFrame, cfgItemGame, false)) {
                return;
            }
            if (vectrexMemory.isCartridgeBankable() && n2 != vectrexMemory.getSelectedCartBank()) {
                vectrexMemory.selectBank(n2);
            }
            String string2 = string = cfgItemGame.cartridge.built ? "rebuilt" : "reloaded";
            if (this.resetAfterReload == null) {
                JCheckBox jCheckBox = new JCheckBox("Do not ask again (until next restart)");
                n = JOptionPane.showConfirmDialog(jFrame, new Object[]{"The Cartridge image was successfully reloaded\nDo you want to RESET the execution?\n \n", new JSeparator(), jCheckBox}, "ParaJVE - Cartridge " + string, 0);
                if (jCheckBox.isSelected()) {
                    this.resetAfterReload = new Integer(n);
                }
            } else {
                n = this.resetAfterReload;
            }
            if (n == 0) {
                Vectrex.INSTANCE.reset();
            }
        }
        finally {
            if (bl) {
                this.setPaused(false);
            }
        }
    }

    public void injectRamInCartridgeImpl() {
        boolean bl;
        boolean bl2 = bl = !this.isPaused();
        if (bl) {
            this.setPaused(true);
        }
        try {
            if (Vectrex.INSTANCE.getMemory().isCartridgeBankable()) {
                JOptionPane.showMessageDialog(this.getWindow(), "State injection in multi-banked binaries is not supported...", "Injection not possible", 1);
                return;
            }
            IStream iStream = this.getConfig().getSelectedGame().getCartridgeStream();
            if (!StateInjector.canInjectJOY2(iStream)) {
                JOptionPane.showMessageDialog(this.getWindow(), "Cannot find any call to hook the patch on...", "Injection not possible", 2);
                return;
            }
            String string = this.getConfig().options.lastPathInjections;
            boolean bl3 = false;
            if (string == null) {
                string = String.valueOf(UI.getDataDevRoot()) + "/roms/injected";
                bl3 = true;
            }
            File file = new File(string, "injected-" + iStream.getStreamName());
            FileRequester fileRequester = new FileRequester(this.getWindow());
            fileRequester.setInitialFile(file, bl3);
            file = fileRequester.requestSave("Save injected binary as...");
            if (file == null) {
                return;
            }
            this.storeLastPathInjections(file);
            Vectrex vectrex = Vectrex.INSTANCE;
            boolean bl4 = StateInjector.injectJOY2(iStream, file, vectrex.getMemory().getMemory(51200), vectrex.getCPU().getRegisters());
            if (bl4) {
                String string2 = "<html><font color=#006000>RAM & Registers state successfully injected into binary:<br><b>" + Utils.getRelativePath(file) + "</b></font><p><hr>" + "When running this modified binary, you can instantly reload the<br>" + "injected state by pressing one button of the second joystick.<br><br>" + "<b>This will work on a real vectrex too!</b><br><br>";
                JOptionPane.showMessageDialog(this.getWindow(), string2, "Injection successful", 1);
            } else {
                JOptionPane.showMessageDialog(this.getWindow(), "Unexpected error while injecting state into binary:\n" + Utils.getRelativePath(file), "Injection failed", 0);
            }
        }
        finally {
            if (bl) {
                this.setPaused(false);
            }
        }
    }

    File saveImpl(PersistenceManager.SaveType saveType, PersistentFileProvider persistentFileProvider, String string, String string2) {
        File file;
        block13: {
            boolean bl;
            boolean bl2 = bl = !this.isPaused();
            if (bl) {
                this.setPaused(true);
            }
            file = null;
            try {
                try {
                    file = persistentFileProvider.getFile();
                    if (file != null) {
                        Vectrex.INSTANCE.getPersistenceManager().store(file, saveType);
                        if (string2 != null) {
                            JOptionPane.showMessageDialog(this.getWindow(), string2, string, 1);
                        }
                    }
                }
                catch (PersistenceException persistenceException) {
                    boolean bl3 = file != null;
                    String string3 = String.valueOf(bl3 ? "<html><b>" : "") + persistenceException.getMessage();
                    if (bl3) {
                        string3 = String.valueOf(string3) + "</b>&nbsp;<br><br><hr>" + Utils.getRelativePath(file) + "&nbsp;<br><br>";
                    }
                    JOptionPane.showMessageDialog(this.getWindow(), string3, "Saving Error", 0);
                    persistenceException.printStackTrace(System.err);
                    if (bl) {
                        this.setPaused(false);
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.setPaused(false);
                }
                throw throwable;
            }
            if (bl) {
                this.setPaused(false);
            }
        }
        if (file != null) {
            System.out.println("Successfully saved state to file [" + Utils.getRelativePath(file) + "]");
        }
        return file;
    }

    File loadImpl(PersistentFileProvider persistentFileProvider) {
        boolean bl;
        File file;
        block14: {
            boolean bl2;
            boolean bl3 = bl2 = !this.isPaused();
            if (bl2) {
                this.setPaused(true);
            }
            file = null;
            bl = false;
            try {
                try {
                    file = persistentFileProvider.getFile();
                    if (file != null) {
                        Vectrex.INSTANCE.getPersistenceManager().load(file);
                        bl = true;
                    }
                }
                catch (PersistenceException persistenceException) {
                    boolean bl4 = file != null;
                    String string = String.valueOf(bl4 ? "<html><b>" : "") + persistenceException.getMessage();
                    if (bl4) {
                        string = String.valueOf(string) + "</b>&nbsp;<br><br><hr>" + Utils.getRelativePath(file) + "&nbsp;<br><br>";
                    }
                    JOptionPane.showMessageDialog(this.getWindow(), string, "Loading Error", 0);
                    persistenceException.printStackTrace(System.err);
                    if (bl2) {
                        this.setPaused(false);
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (bl2) {
                    this.setPaused(false);
                }
                throw throwable;
            }
            if (bl2) {
                this.setPaused(false);
            }
        }
        if (bl) {
            System.out.println("Successfully loaded state from file [" + Utils.getRelativePath(file) + "]");
        } else if (file != null) {
            System.out.println("Failed to load state from file [" + Utils.getRelativePath(file) + "]");
        }
        return file;
    }

    PersistentFileProvider getQuickStorageProvider(final boolean bl) {
        return new PersistentFileProvider(){

            public File getFile() throws PersistenceException {
                File file = Vectrex.INSTANCE.getPersistenceManager().getQuickSlotFile();
                if (bl && file != null && !file.isFile()) {
                    JOptionPane.showMessageDialog(UIInOut.this.getWindow(), "No Quick save found for the current game.", "Quick Load", 1);
                    return null;
                }
                return file;
            }
        };
    }

    PersistentFileProvider getSaveProvider() {
        return new PersistentFileProvider(){

            public File getFile() throws PersistenceException {
                File file = Vectrex.INSTANCE.getPersistenceManager().getUserSlotFile();
                FileRequester fileRequester = UIInOut.this.getStorageChooser(file);
                File file2 = fileRequester.requestSave("Save...", ".jvesav");
                UIInOut.this.storeLastPathUserSave(file2);
                return file2;
            }
        };
    }

    PersistentFileProvider getLoadProvider() {
        return new PersistentFileProvider(){

            public File getFile() throws PersistenceException {
                File file = Vectrex.INSTANCE.getPersistenceManager().getUserSlotFile();
                FileRequester fileRequester = UIInOut.this.getStorageChooser(file);
                File file2 = fileRequester.requestOpen("Load...");
                UIInOut.this.storeLastPathUserSave(file2);
                while (file2 != null) {
                    String string = PersistenceManager.isValidSaveFile(file2);
                    if (string == null) break;
                    JOptionPane.showMessageDialog(UIInOut.this.getWindow(), "<html><font color=RED><b>ERROR : </b>Cannot load the content of the selected file</font><hr><br><b>Cause : </b>" + string + "<br><br>", "Loading Error...", 2);
                    file2 = fileRequester.requestOpenAgain();
                }
                return file2;
            }
        };
    }

    private FileRequester getStorageChooser(File file) {
        FileRequester fileRequester = this.storageChooser;
        if (fileRequester == null) {
            fileRequester = new FileRequester(this.getWindow());
            fileRequester.setInitialFile(file, true);
            fileRequester.addFileExtensionFilter("ParaJVE save files (*.jvesav)", ".jvesav");
            fileRequester.addFilter(Vectrex.INSTANCE.getPersistenceManager().createContentFileFilter(true));
            UIInOut.hookSaveGamePreview(fileRequester.getChooser());
            this.storageChooser = fileRequester;
        } else {
            file = fileRequester.getChooser().getSelectedFile();
            fileRequester.getChooser().setSelectedFile(null);
            fileRequester.setInitialFile(file, false);
        }
        return fileRequester;
    }

    static boolean loadCartridge(Window window, CfgItemGame cfgItemGame, boolean bl) {
        Object object;
        VectrexMemory vectrexMemory = Vectrex.INSTANCE.getMemory();
        if (cfgItemGame == null || !cfgItemGame.hasCartridge()) {
            vectrexMemory.removeCartridge();
            vectrexMemory.removeCartridgeRAM();
            return true;
        }
        File file = Utils.getFile(cfgItemGame.cartridge.getCartridgePath());
        if (cfgItemGame.cartridge.built && (file = ((UIGameBuilder)(object = new UIGameBuilder())).buildGame(window, file.getPath())) == null) {
            return false;
        }
        if (bl) {
            object = cfgItemGame.cartridge.built ? "Building" : "Loading";
        } else {
            Object object2 = object = cfgItemGame.cartridge.built ? "Rebuilding" : "Reloading";
        }
        if (!file.isFile()) {
            JOptionPane.showMessageDialog(window, "Cannot find Cartridge ROM file [" + file.getPath() + "]", "ParaJVE - " + (String)object + " aborted", 2);
            return false;
        }
        try {
            IStream iStream = cfgItemGame.cartridge.built ? IStreamFactory.create(file) : cfgItemGame.getCartridgeStream();
            System.out.println(String.valueOf(object) + " Cartridge ROM from [" + iStream.getName() + "]");
            vectrexMemory.loadCartridge(iStream.open());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(window, "Error while " + ((String)object).toLowerCase() + " the Cartridge ROM file", "ParaJVE - " + (String)object + " error", 0);
            exception.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    private static void hookSaveGamePreview(JFileChooser jFileChooser) {
        final PreviewCanvas previewCanvas = new PreviewCanvas();
        Dimension dimension = new Dimension(233, 311);
        previewCanvas.setPreferredSize(dimension);
        previewCanvas.setMinimumSize(dimension);
        previewCanvas.setMaximumSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(previewCanvas);
        jPanel.setOpaque(false);
        if (!Utils.isMacOSX()) {
            jPanel.setBorder(new EmptyBorder(0, 10, 0, 0));
            Dimension dimension2 = jFileChooser.getPreferredSize();
            jFileChooser.setAccessory(jPanel);
            Dimension dimension3 = jFileChooser.getPreferredSize();
            dimension3.width = (3 * dimension2.width + dimension3.width) / 4;
            dimension3.height = Math.max(dimension2.height, dimension3.height);
            jFileChooser.setPreferredSize(dimension3);
        } else {
            jPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
            jFileChooser.setAccessory(jPanel);
        }
        jFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                    File file = (File)propertyChangeEvent.getNewValue();
                    UIInOut.updatePreview(previewCanvas, file);
                }
            }
        });
        UIInOut.updatePreview(previewCanvas, jFileChooser.getSelectedFile());
    }

    private static void updatePreview(PreviewCanvas previewCanvas, File file) {
        if (file != null && file.isFile()) {
            try {
                List<GfxItem> list = HeadlessDisplay.loadGraphics(file);
                previewCanvas.setGraphicItems(list, true);
                return;
            }
            catch (PersistenceException persistenceException) {}
        }
        previewCanvas.setGraphicItems(null, false);
    }

    private void storeLastPathUserSave(File file) {
        Configuration configuration = this.getConfig();
        configuration.options.storeLastPathUserSave(file, configuration);
    }

    private void storeLastPathSnapshots(File file) {
        Configuration configuration = this.getConfig();
        configuration.options.storeLastPathSnapshots(file, configuration);
    }

    private void storeLastPathInjections(File file) {
        Configuration configuration = this.getConfig();
        configuration.options.storeLastPathInjections(file, configuration);
    }

    private static interface PersistentFileProvider {
        public File getFile() throws PersistenceException;
    }
}

